/*
 * Decompiled with CFR 0.152.
 */
package org.cesar.inmotion.sea.basic;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import org.cesar.inmotion.sea.Constants;
import org.cesar.inmotion.sea.GameCanvas;
import org.cesar.inmotion.sea.basic.Fire;
import org.cesar.inmotion.sea.basic.Fish;
import org.cesar.inmotion.util.GameItem;

public class Diver
extends GameItem {
    private final byte STEP = (byte)2;
    private short img_col;
    private short img_lin;
    public boolean repeatLeft;
    public boolean repeatRight;
    public boolean repeatDown;
    public boolean repeatUp;
    public boolean atSurface = true;
    private Fire fire;
    private byte fishcount;
    public int breath = 1000;

    public Diver(Image image) {
        super(0, 0, image);
        this.setVisible(true);
        this.setXspeed(3);
        this.setYspeed(3);
        this.fire = new Fire(0, 0, true, null);
        this.fire();
        this.init();
    }

    public void init() {
        this.setY(GameCanvas.SurfaceY - 5);
        this.setX(GameCanvas.ScreenWidth / 2 - this.getImage().getWidth() / 2);
        this.setImage(Constants.img_diver_surface[this.img_col]);
        this.atSurface = true;
    }

    public void update() {
        this.fire.setY(this.getY() + 7);
        if (this.atSurface) {
            if (this.breath < 985) {
                this.breath += 15;
            } else {
                this.breath = 1000;
                Constants.score = this.fishcount < 6 ? (Constants.score += this.fishcount * 2) : (Constants.score += this.fishcount * 10 + this.breath / 100);
                this.fishcount = 0;
            }
        } else {
            if (!this.fire.isVisible()) {
                this.fire();
            }
            this.breath = this.breath < 2 ? 0 : (this.breath -= 2);
            if (this.breath == 0) {
                GameCanvas.getInstance().die();
                this.breath = 1000;
            }
        }
        if (this.repeatLeft && this.getX() > 0) {
            this.setX(this.getX() - this.getXspeed());
            this.img_col = 0;
        }
        if (this.repeatRight && this.getX() < GameCanvas.ScreenWidth - this.getImage().getWidth()) {
            this.setX(this.getX() + this.getXspeed());
            this.img_col = 1;
        }
        if (this.repeatDown && (!this.atSurface || this.atSurface && this.getFishcount() == 0) && this.getY() < GameCanvas.ScreenHeight - 10) {
            this.setY(this.getY() + this.getYspeed());
        }
        if (this.repeatUp) {
            if (this.getY() > GameCanvas.SurfaceY - 5) {
                this.setY(this.getY() - this.getYspeed());
            } else {
                this.setImage(Constants.img_diver_surface[this.img_col]);
                if (!this.atSurface) {
                    this.atSurface = true;
                    if (this.getFishcount() == 0 && this.breath < 1000) {
                        GameCanvas.getInstance().die();
                    }
                }
            }
        }
        if (this.getY() > GameCanvas.SurfaceY) {
            this.atSurface = false;
            if (this.breath < 300 && GameCanvas.frame % 10 <= 5) {
                this.setImage(Constants.img_diver_blowing);
            } else {
                this.setImage(Constants.img_diver[this.img_col][this.img_lin]);
            }
            if (GameCanvas.frame % 10 == 5) {
                this.img_lin = (short)(this.img_lin + 1);
                this.img_lin = (short)(this.img_lin % 4);
            }
        }
        this.processIntersection();
    }

    private void processIntersection() {
        byte by = 0;
        while (by < GameCanvas.attack.getSharkCount()) {
            Fish fish = GameCanvas.attack.getShark(by);
            Fish fish2 = GameCanvas.attack.getFish(by);
            if (fish.isVisible() && !fish.isDead() && this.intersects(fish)) {
                fish.kill();
                fish.setVisible(false);
                System.out.println("Ops!");
                GameCanvas.getInstance().die();
            }
            if (this.fishcount < 6 && fish2.isVisible() && !fish2.isDead() && this.intersects(fish2)) {
                fish2.kill();
                fish2.setVisible(false);
                System.out.println("Gotcha!");
                if (this.fishcount < 6) {
                    this.fishcount = (byte)(this.fishcount + 1);
                }
            }
            by = (byte)(by + 1);
        }
    }

    public void draw(Graphics graphics) {
    }

    public void fire() {
        this.fire.setY((short)this.getY() + 7);
        if (this.img_col == 1) {
            this.fire.setImage(Constants.img_fire[1]);
            this.fire.setXspeed((short)(-Math.abs(this.fire.getXspeed())));
            this.fire.setX((short)this.getX() + this.getImage().getWidth());
        } else {
            this.fire.setImage(Constants.img_fire[0]);
            this.fire.setXspeed((short)Math.abs(this.fire.getXspeed()));
            this.fire.setX((short)this.getX());
        }
        this.fire.setVisible(true);
    }

    public byte getFishcount() {
        return this.fishcount;
    }

    public void setFishcount(byte by) {
        this.fishcount = by;
    }

    public Fire getFire() {
        return this.fire;
    }
}

